"use strict";
// This helper allows logs to either be printed to the console as they would normally or if
// the USE_LOG_FILE environment variable is set (such as through our playwright tests), then
// the logs can be diverted from the command line to a log file, so that they can be displayed
// later (such as at the end of a playwright test run to help diagnose potential failures).
// Use this instead of loglevel whenever logging messages inside the app.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.warn = exports.trace = exports.setLevel = exports.log = exports.info = exports.error = exports.debug = void 0;
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const loglevel_1 = __importDefault(require("loglevel"));
const playwrightHelpers_1 = require("./playwrightHelpers");
const USE_LOG_FILE = (0, playwrightHelpers_1.safeGetEnv)('USE_LOG_FILE') === '1';
const LOG_FILE_DIR = (_a = (0, playwrightHelpers_1.safeGetEnv)('LOG_FILE_DIR')) !== null && _a !== void 0 ? _a : process.cwd();
const LOG_FILENAME = path.join(LOG_FILE_DIR, `${new Date().getTime()}.log`);
const logLevelNames = ['TRACE', 'DEBUG', 'INFO ', 'WARN ', 'ERROR'];
function _logger(logFunc, level, ...args) {
    var _a, _b;
    if (USE_LOG_FILE && loglevel_1.default.getLevel() >= level) {
        for (const arg of args) {
            try {
                const lines = 
                // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
                (_b = (_a = JSON.stringify(arg, null, 2)) === null || _a === void 0 ? void 0 : _a.split('\n')) !== null && _b !== void 0 ? _b : `${arg}`.split('\n');
                for (const line of lines) {
                    fs.appendFileSync(LOG_FILENAME, `${new Date().getTime()} ${logLevelNames[level]} ${line}\n`);
                }
            }
            catch (_c) {
                // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
                fs.appendFileSync(LOG_FILENAME, `${logLevelNames[level]} ${arg}\n`);
            }
        }
    }
    else {
        logFunc(...args);
    }
}
function debug(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.debug, loglevel_1.default.levels.DEBUG, ...args);
}
exports.debug = debug;
function error(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.error, loglevel_1.default.levels.ERROR, ...args);
}
exports.error = error;
function info(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.info, loglevel_1.default.levels.INFO, ...args);
}
exports.info = info;
function log(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.info, loglevel_1.default.levels.INFO, ...args);
}
exports.log = log;
function setLevel(level, persist) {
    loglevel_1.default.setLevel(level, persist);
}
exports.setLevel = setLevel;
function trace(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.trace, loglevel_1.default.levels.TRACE, ...args);
}
exports.trace = trace;
function warn(...args) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    _logger(loglevel_1.default.warn, loglevel_1.default.levels.WARN, ...args);
}
exports.warn = warn;
//# sourceMappingURL=loggingHelper.js.map