import { BrowserWindow, OpenExternalOptions } from 'electron';
export declare const INJECT_DIR: string;
export declare function isUrlShellSafe(urlToGo: string): {
    blocked: false;
} | {
    blocked: true;
    reason: string;
};
/**
 * Helper to print debug messages from the main process in the browser window
 */
export declare function debugLog(browserWindow: BrowserWindow, message: string): void;
export declare function getAppIcon(): string | undefined;
export declare function getCounterValue(title: string): string | undefined;
export declare function getCSSToInject(): string;
export declare function isOSX(): boolean;
export declare function isLinux(): boolean;
export declare function isWindows(): boolean;
export declare function linkIsInternal(currentUrl: string, newUrl: string, internalUrlRegex: string | RegExp | undefined, isStrictInternalUrlsEnabled: boolean | undefined): boolean;
export declare function nativeTabsSupported(): boolean;
/**
 * Open the given external protocol URL in the desktop's default manner
 * (e.g. `mailto:` URLs in the user's default mail agent), with extra validation.
 */
export declare function openExternal(url: string, options?: OpenExternalOptions): Promise<void>;
export declare function isWayland(): boolean;
export declare function removeUserAgentSpecifics(userAgentFallback: string, appName: string, appVersion: string): string;
/** Removes extra spaces from a text */
export declare function cleanupPlainText(text: string): string;
