"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initContextMenu = void 0;
const electron_context_menu_1 = __importDefault(require("electron-context-menu"));
const helpers_1 = require("../helpers/helpers");
const log = __importStar(require("../helpers/loggingHelper"));
const windowEvents_1 = require("../helpers/windowEvents");
const windowHelpers_1 = require("../helpers/windowHelpers");
const model_1 = require("../../../shared/src/options/model");
function initContextMenu(options, window) {
    log.debug('initContextMenu');
    // eslint-disable-next-line @typescript-eslint/no-unsafe-call
    (0, electron_context_menu_1.default)({
        prepend: (actions, params) => {
            log.debug('contextMenu.prepend', { actions, params });
            const items = [];
            if (params.linkURL && window) {
                items.push({
                    label: 'Open Link in Default Browser',
                    click: () => {
                        (0, helpers_1.openExternal)(params.linkURL).catch((err) => log.error('contextMenu Open Link in Default Browser ERROR', err));
                    },
                });
                items.push({
                    label: 'Open Link in New Window',
                    click: () => (0, windowHelpers_1.createNewWindow)((0, model_1.outputOptionsToWindowOptions)(options, (0, helpers_1.nativeTabsSupported)()), windowEvents_1.setupNativefierWindow, params.linkURL),
                });
                if ((0, helpers_1.nativeTabsSupported)()) {
                    items.push({
                        label: 'Open Link in New Tab',
                        click: () => 
                        // // Fire a new window event for a foreground tab
                        // // Previously we called createNewTab directly, but it had incosistent and buggy behavior
                        // // as it was mostly designed for running off of events. So this will create a new event
                        // // for a foreground-tab for the event handler to grab and take care of instead.
                        // (window as BrowserWindow).webContents.emit(
                        //   // event name
                        //   'new-window',
                        //   // event object
                        //   {
                        //     // Leave to the default for a NewWindowWebContentsEvent
                        //     newGuest: undefined,
                        //     ...new Event('new-window'),
                        //   }, // as NewWindowWebContentsEvent,
                        //   // url
                        //   params.linkURL,
                        //   // frameName
                        //   window?.webContents.mainFrame.name ?? '',
                        //   // disposition
                        //   'foreground-tab',
                        // ),
                        window.emit('new-window-for-tab', {
                            ...new Event('new-window-for-tab'),
                            url: params.linkURL,
                        }),
                    });
                }
            }
            return items;
        },
        showCopyImage: true,
        showCopyImageAddress: true,
        showSaveImage: true,
    });
}
exports.initContextMenu = initContextMenu;
//# sourceMappingURL=contextMenu.js.map