"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTrayIcon = void 0;
const electron_1 = require("electron");
const helpers_1 = require("../helpers/helpers");
const log = __importStar(require("../helpers/loggingHelper"));
function createTrayIcon(nativefierOptions, mainWindow) {
    var _a;
    const options = { ...nativefierOptions };
    if (options.tray && options.tray !== 'false') {
        const iconPath = (0, helpers_1.getAppIcon)();
        if (!iconPath) {
            throw new Error('Icon path not found found to use with tray option.');
        }
        const nimage = electron_1.nativeImage.createFromPath(iconPath);
        const appIcon = new electron_1.Tray(electron_1.nativeImage.createEmpty());
        if ((0, helpers_1.isOSX)()) {
            //sets the icon to the height of the tray.
            appIcon.setImage(nimage.resize({ height: appIcon.getBounds().height - 2 }));
        }
        else {
            appIcon.setImage(nimage);
        }
        const onClick = () => {
            log.debug('onClick');
            if (mainWindow.isVisible()) {
                mainWindow.hide();
            }
            else {
                mainWindow.show();
            }
        };
        const contextMenu = electron_1.Menu.buildFromTemplate([
            {
                label: options.name,
                click: onClick,
            },
            {
                label: 'Quit',
                click: () => electron_1.app.exit(0),
            },
        ]);
        appIcon.on('click', onClick);
        if (options.counter) {
            mainWindow.on('page-title-updated', (event, title) => {
                var _a, _b;
                log.debug('mainWindow.page-title-updated', { event, title });
                const counterValue = (0, helpers_1.getCounterValue)(title);
                if (counterValue) {
                    appIcon.setToolTip(`(${counterValue})  ${(_a = options.name) !== null && _a !== void 0 ? _a : 'Nativefier'}`);
                }
                else {
                    appIcon.setToolTip((_b = options.name) !== null && _b !== void 0 ? _b : '');
                }
            });
        }
        else {
            electron_1.ipcMain.on('notification', () => {
                log.debug('ipcMain.notification');
                if (mainWindow.isFocused()) {
                    return;
                }
                if (options.name) {
                    appIcon.setToolTip(`•  ${options.name}`);
                }
            });
            mainWindow.on('focus', () => {
                var _a;
                log.debug('mainWindow.focus');
                appIcon.setToolTip((_a = options.name) !== null && _a !== void 0 ? _a : '');
            });
        }
        appIcon.setToolTip((_a = options.name) !== null && _a !== void 0 ? _a : '');
        appIcon.setContextMenu(contextMenu);
        return appIcon;
    }
    return undefined;
}
exports.createTrayIcon = createTrayIcon;
//# sourceMappingURL=trayIcon.js.map